/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git;

import com.axone_io.ignition.git.GatewayScriptModule;
import com.axone_io.ignition.git.commissioning.utils.GitCommissioningUtils;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.axone_io.ignition.git.records.GitReposUsersRecord;
import com.axone_io.ignition.git.web.GitProjectsConfigPage;
import com.inductiveautomation.ignition.common.BundleUtil;
import com.inductiveautomation.ignition.common.licensing.LicenseState;
import com.inductiveautomation.ignition.gateway.clientcomm.ClientReqSession;
import com.inductiveautomation.ignition.gateway.localdb.persistence.RecordMeta;
import com.inductiveautomation.ignition.gateway.model.AbstractGatewayModuleHook;
import com.inductiveautomation.ignition.gateway.model.GatewayContext;
import com.inductiveautomation.ignition.gateway.web.models.ConfigCategory;
import com.inductiveautomation.ignition.gateway.web.models.IConfigTab;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayHook
extends AbstractGatewayModuleHook {
    public static String MODULE_NAME = "Git";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private GatewayScriptModule scriptModule;
    public static GatewayContext context;
    public static final ConfigCategory CONFIG_CATEGORY;

    public List<? extends IConfigTab> getConfigPanels() {
        return List.of(GitProjectsConfigPage.MENU_ENTRY);
    }

    public List<ConfigCategory> getConfigCategories() {
        return Collections.singletonList(CONFIG_CATEGORY);
    }

    public void setup(GatewayContext gatewayContext) {
        context = gatewayContext;
        this.scriptModule = new GatewayScriptModule(context);
        BundleUtil.get().addBundle("bundle_git", ((Object)((Object)this)).getClass(), "bundle_git");
        this.verifySchema(gatewayContext);
        this.logger.info("setup()");
    }

    private void verifySchema(GatewayContext context) {
        try {
            context.getSchemaUpdater().updatePersistentRecords(new RecordMeta[]{GitProjectsConfigRecord.META, GitReposUsersRecord.META});
        }
        catch (SQLException e) {
            this.logger.error("Error verifying persistent record schemas for HomeConnect records.", (Throwable)e);
        }
    }

    public void startup(LicenseState licenseState) {
        GitCommissioningUtils.loadConfiguration();
        this.logger.info("startup()");
    }

    public void shutdown() {
        this.logger.info("shutdown()");
    }

    public boolean isFreeModule() {
        return true;
    }

    public boolean isMakerEditionCompatible() {
        return true;
    }

    public Object getRPCHandler(ClientReqSession session, String projectName) {
        return this.scriptModule;
    }

    static {
        CONFIG_CATEGORY = new ConfigCategory(MODULE_NAME, "bundle_git.Config.Git.MenuTitle", 700);
    }
}

