/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git;

import com.axone_io.ignition.git.AbstractScriptModule;
import com.axone_io.ignition.git.managers.GitImageManager;
import com.axone_io.ignition.git.managers.GitManager;
import com.axone_io.ignition.git.managers.GitProjectManager;
import com.axone_io.ignition.git.managers.GitTagManager;
import com.axone_io.ignition.git.managers.GitThemeManager;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.inductiveautomation.ignition.common.BasicDataset;
import com.inductiveautomation.ignition.common.Dataset;
import com.inductiveautomation.ignition.common.util.DatasetBuilder;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.model.GatewayContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;

public class GatewayScriptModule
extends AbstractScriptModule {
    private final LoggerEx logger = LoggerEx.newBuilder().build(((Object)((Object)this)).getClass());
    private final GatewayContext context;

    GatewayScriptModule(GatewayContext context) {
        this.context = context;
    }

    public boolean pullImpl(String projectName, String userName, boolean importTags, boolean importTheme, boolean importImages) throws Exception {
        try (Git git = GitManager.getGit(this.getProjectFolderPath(projectName));){
            PullCommand pull = git.pull();
            GitManager.setAuthentication(pull, projectName, userName);
            PullResult result = pull.call();
            if (!result.isSuccessful()) {
                this.logger.warn("Cannot pull from git");
            } else {
                this.logger.info("Pull was successful.");
            }
            GitProjectManager.importProject(projectName);
            if (importTags) {
                GitTagManager.importTagManager(projectName);
            }
            if (importTheme) {
                GitThemeManager.importTheme(projectName);
            }
            if (importImages) {
                GitImageManager.importImages(projectName);
            }
        }
        catch (GitAPIException e) {
            this.logger.error(e.toString());
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean pushImpl(String projectName, String userName) throws Exception {
        try (Git git = GitManager.getGit(this.getProjectFolderPath(projectName));){
            PushCommand push = git.push();
            GitManager.setAuthentication(push, projectName, userName);
            Iterable results = push.setPushAll().setPushTags().call();
            for (PushResult result : results) {
                this.logger.trace(result.getMessages());
            }
        }
        catch (GitAPIException e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    protected boolean commitImpl(String projectName, String userName, List<String> changes, String message) {
        try (Git git = GitManager.getGit(this.getProjectFolderPath(projectName));){
            for (String change : changes) {
                git.add().addFilepattern(change).call();
                git.add().setUpdate(true).addFilepattern(change).call();
            }
            CommitCommand commit = git.commit().setMessage(message);
            GitManager.setCommitAuthor(commit, projectName, userName);
            commit.call();
        }
        catch (GitAPIException e) {
            this.logger.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public Dataset getUncommitedChangesImpl(String projectName, String userName) {
        Path projectPath = this.getProjectFolderPath(projectName);
        ArrayList<String> changes = new ArrayList<String>();
        DatasetBuilder builder = new DatasetBuilder();
        builder.colNames(List.of("resource", "type", "actor"));
        builder.colTypes(List.of(String.class, String.class, String.class));
        try (Git git = GitManager.getGit(projectPath);){
            Status status = git.status().call();
            Set missing = status.getMissing();
            this.logger.debug("Missing files: {}" + missing);
            GitManager.uncommittedChangesBuilder(projectName, missing, "Deleted", changes, builder);
            Set uncommittedChanges = status.getUncommittedChanges();
            this.logger.debug("Uncommitted changes: {}" + uncommittedChanges);
            GitManager.uncommittedChangesBuilder(projectName, uncommittedChanges, "Uncommitted", changes, builder);
            Set untracked = status.getUntracked();
            this.logger.debug("Untracked files: {}" + untracked);
            GitManager.uncommittedChangesBuilder(projectName, untracked, "Created", changes, builder);
            Set modified = status.getChanged();
            this.logger.debug("Modified files: {}" + modified);
            GitManager.uncommittedChangesBuilder(projectName, modified, "Modified", changes, builder);
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
        Dataset ds = builder.build();
        return ds != null ? ds : new BasicDataset();
    }

    public boolean isRegisteredUserImpl(String projectName, String userName) {
        boolean registered;
        try {
            GitProjectsConfigRecord gitProjectsConfigRecord = GitManager.getGitProjectConfigRecord(projectName);
            GitManager.getGitReposUserRecord(gitProjectsConfigRecord, userName);
            registered = true;
        }
        catch (Exception e) {
            registered = false;
        }
        return registered;
    }

    protected boolean exportConfigImpl(String projectName) {
        Path projectFolderPath = this.getProjectFolderPath(projectName);
        GitImageManager.exportImages(projectFolderPath);
        GitThemeManager.exportTheme(projectFolderPath);
        GitTagManager.exportTag(projectFolderPath);
        return true;
    }

    public void setupLocalRepoImpl(String projectName, String userName) throws Exception {
        Path projectFolderPath = this.getProjectFolderPath(projectName);
        GitProjectsConfigRecord gitProjectsConfigRecord = GitManager.getGitProjectConfigRecord(projectName);
        Path path = projectFolderPath.resolve(".git");
        if (!Files.exists(path, new LinkOption[0])) {
            try (Git git = Git.init().setDirectory(projectFolderPath.toFile()).call();){
                GitManager.disableSsl(git);
                URIish urIish = new URIish(gitProjectsConfigRecord.getURI());
                git.remoteAdd().setName("origin").setUri(urIish).call();
                FetchCommand fetch = git.fetch().setRemote("origin");
                GitManager.setAuthentication(fetch, projectName, userName);
                fetch.call();
                ListBranchCommand listBranches = git.branchList();
                listBranches.setListMode(ListBranchCommand.ListMode.REMOTE);
                List branches = listBranches.call();
                if (branches.isEmpty()) {
                    this.setupGitFromCurrentFolder(projectName, userName, git);
                } else {
                    this.setupGitFromRemoteRepo(projectName, git);
                }
            }
            catch (Exception e) {
                this.logger.warn("An error occurred while setting up local repo for '" + projectName + "' project.", (Throwable)e);
            }
        }
    }

    private void setupGitFromCurrentFolder(String projectName, String userName, Git git) throws Exception {
        try {
            git.add().addFilepattern(".").call();
            CommitCommand commit = git.commit().setMessage("Initial commit");
            GitManager.setCommitAuthor(commit, projectName, userName);
            commit.call();
            PushCommand pushCommand = git.push();
            GitManager.setAuthentication(pushCommand, projectName, userName);
            String branch = git.getRepository().getBranch();
            pushCommand.setRemote("origin").setRefSpecs(new RefSpec[]{new RefSpec(branch)}).call();
        }
        catch (GitAPIException e) {
            this.logger.error(e.toString());
            throw new RuntimeException(e);
        }
    }

    private void setupGitFromRemoteRepo(String projectName, Git git) throws Exception {
        try {
            CheckoutCommand checkout = git.checkout().setName("master").setCreateBranch(true).setForced(true).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/master");
            checkout.call();
            git.clean().setForce(true).call();
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            GitTagManager.importTagManager(projectName);
            GitThemeManager.importTheme(projectName);
            GitImageManager.importImages(projectName);
        }
        catch (GitAPIException e) {
            this.logger.error(e.toString());
            throw new RuntimeException(e);
        }
    }

    private Path getProjectFolderPath(String projectName) {
        Path dataDir = this.context.getSystemManager().getDataDir().toPath();
        return dataDir.resolve("projects").resolve(projectName);
    }
}

