/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.commissioning;

import com.axone_io.ignition.git.commissioning.ProjectConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public class GitCommissioningConfig {
    private String repoURI;
    private String repoBranch;
    private String ignitionProjectName;
    private String ignitionUserName;
    private boolean ignitionProjectInheritable;
    @Nullable
    private String ignitionProjectParentName;
    private String userName;
    private String userPassword;
    private String sshKey;
    private String userEmail;
    private boolean importImages = false;
    private boolean importTags = false;
    private boolean importThemes = false;
    private String initDefaultBranch;

    public void loadFromProjectConfig(ProjectConfig projectConfig) {
        this.repoURI = projectConfig.getRepo_uri();
        this.repoBranch = projectConfig.getRepo_branch();
        this.ignitionProjectName = projectConfig.getIgnition_projectName();
        this.ignitionUserName = projectConfig.getIgnition_userName();
        this.ignitionProjectInheritable = projectConfig.getIgnition_inheritable();
        this.ignitionProjectParentName = projectConfig.getIgnition_parentName();
        this.userName = projectConfig.getUser_name();
        this.userEmail = projectConfig.getUser_email();
        this.userPassword = projectConfig.getUser_password();
        this.importImages = projectConfig.getCommissioning_importImages();
        this.importTags = projectConfig.getCommissioning_importTags();
        this.importThemes = projectConfig.getCommissioning_importThemes();
        this.initDefaultBranch = projectConfig.getInitDefaultBranch();
    }

    public void setSecretFromFilePath(Path filePath, boolean isSSHAuth) throws IOException {
        if (filePath.toFile().exists() && filePath.toFile().isFile()) {
            String secret = Files.readString(filePath, StandardCharsets.UTF_8);
            if (isSSHAuth) {
                this.sshKey = secret;
            } else {
                this.userPassword = secret;
            }
        }
    }

    public String getRepoURI() {
        return this.repoURI;
    }

    public void setRepoURI(String repoURI) {
        this.repoURI = repoURI;
    }

    public String getRepoBranch() {
        return this.repoBranch;
    }

    public void setRepoBranch(String repoBranch) {
        this.repoBranch = repoBranch;
    }

    public String getIgnitionProjectName() {
        return this.ignitionProjectName;
    }

    public void setIgnitionProjectName(String ignitionProjectName) {
        this.ignitionProjectName = ignitionProjectName;
    }

    public String getIgnitionUserName() {
        return this.ignitionUserName;
    }

    public void setIgnitionUserName(String ignitionUserName) {
        this.ignitionUserName = ignitionUserName;
    }

    public boolean isIgnitionProjectInheritable() {
        return this.ignitionProjectInheritable;
    }

    public void setIgnitionProjectInheritable(boolean ignitionProjectInheritable) {
        this.ignitionProjectInheritable = ignitionProjectInheritable;
    }

    @Nullable
    public String getIgnitionProjectParentName() {
        return this.ignitionProjectParentName;
    }

    public void setIgnitionProjectParentName(@Nullable String ignitionProjectParentName) {
        this.ignitionProjectParentName = ignitionProjectParentName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public void setSshKey(String sshKey) {
        this.sshKey = sshKey;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public boolean isImportImages() {
        return this.importImages;
    }

    public void setImportImages(boolean importImages) {
        this.importImages = importImages;
    }

    public boolean isImportTags() {
        return this.importTags;
    }

    public void setImportTags(boolean importTags) {
        this.importTags = importTags;
    }

    public boolean isImportThemes() {
        return this.importThemes;
    }

    public void setImportThemes(boolean importThemes) {
        this.importThemes = importThemes;
    }

    public String getInitDefaultBranch() {
        return this.initDefaultBranch;
    }

    public void setInitDefaultBranch(String initDefaultBranch) {
        this.initDefaultBranch = initDefaultBranch;
    }
}

