/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.commissioning.utils;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.commissioning.GitCommissioningConfig;
import com.axone_io.ignition.git.commissioning.ProjectConfig;
import com.axone_io.ignition.git.commissioning.ProjectConfigs;
import com.axone_io.ignition.git.managers.GitImageManager;
import com.axone_io.ignition.git.managers.GitManager;
import com.axone_io.ignition.git.managers.GitProjectManager;
import com.axone_io.ignition.git.managers.GitTagManager;
import com.axone_io.ignition.git.managers.GitThemeManager;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.axone_io.ignition.git.records.GitReposUsersRecord;
import com.google.common.eventbus.Subscribe;
import com.inductiveautomation.ignition.common.project.ProjectManifest;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistenceInterface;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistentRecord;
import com.inductiveautomation.ignition.gateway.project.ProjectManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.yaml.snakeyaml.Yaml;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SQuery;

public class GitCommissioningUtils {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitCommissioningUtils.class);
    public static GitCommissioningConfig config;

    @Subscribe
    public static void loadConfiguration() {
        Path dataDir = GitManager.getDataFolderPath();
        Path yamlConfigPath = dataDir.resolve("git.yaml");
        ProjectManager projectManager = GatewayHook.context.getProjectManager();
        try {
            if (yamlConfigPath.toFile().exists() && yamlConfigPath.toFile().isFile()) {
                ProjectConfigs projectConfigs = GitCommissioningUtils.parseYaml(yamlConfigPath);
                if (projectConfigs != null) {
                    GitCommissioningConfig gitConfig;
                    for (ProjectConfig projectConfig : projectConfigs.getProjects()) {
                        gitConfig = new GitCommissioningConfig();
                        gitConfig.loadFromProjectConfig(projectConfig);
                        if (gitConfig.getIgnitionProjectParentName() != null && !gitConfig.getIgnitionProjectParentName().isEmpty()) continue;
                        GitCommissioningUtils.processProject(gitConfig, projectManager);
                    }
                    for (ProjectConfig projectConfig : projectConfigs.getProjects()) {
                        gitConfig = new GitCommissioningConfig();
                        gitConfig.loadFromProjectConfig(projectConfig);
                        if (gitConfig.getIgnitionProjectParentName() == null || gitConfig.getIgnitionProjectParentName().isEmpty()) continue;
                        if (!projectManager.getProjectNames().contains(gitConfig.getIgnitionProjectParentName())) {
                            logger.error("Cannot create project '" + gitConfig.getIgnitionProjectName() + "' because parent project '" + gitConfig.getIgnitionProjectParentName() + "' does not exist.");
                            continue;
                        }
                        GitCommissioningUtils.processProject(gitConfig, projectManager);
                    }
                }
            } else {
                logger.info("No git configuration file was found.");
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while git configuration settings up from the provided YAML.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static ProjectConfigs parseYaml(Path yamlFilePath) {
        try (FileInputStream inputStream = new FileInputStream(yamlFilePath.toFile());){
            Yaml yaml = new Yaml();
            Object obj = yaml.load((InputStream)inputStream);
            ProjectConfigs projectConfigs = new ProjectConfigs();
            if (obj instanceof List) {
                List list = (List)obj;
                for (Map item : list) {
                    ProjectConfig config = new ProjectConfig();
                    for (Map.Entry entry : item.entrySet()) {
                        try {
                            String fieldName = GitCommissioningUtils.yamlKeyToFieldName((String)entry.getKey());
                            Field field = ProjectConfig.class.getDeclaredField(fieldName);
                            field.setAccessible(true);
                            Object value = entry.getValue();
                            if (value != null) {
                                if (field.getType().isAssignableFrom(value.getClass())) {
                                    logger.info("Successful addition of field: " + fieldName + ": " + value);
                                    field.set(config, value);
                                    continue;
                                }
                                if (field.getType().equals(Boolean.class) && value instanceof String) {
                                    logger.info("Successful addition of field: " + fieldName + ": " + value);
                                    field.set(config, Boolean.parseBoolean((String)value));
                                    continue;
                                }
                                logger.warn("Unsupported type conversion for field: " + fieldName);
                                continue;
                            }
                            if (!field.getType().isPrimitive()) {
                                field.set(config, null);
                                logger.info("Successful addition of field: " + fieldName + ": null");
                                continue;
                            }
                            System.err.println("Cannot set null value to primitive field: " + fieldName);
                            logger.warn("Cannot set null value to primitive field: " + fieldName);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            logger.error("Error occurred in fetching YAML Git Config data ", (Throwable)e);
                        }
                    }
                    projectConfigs.addProject(config);
                }
                ProjectConfigs projectConfigs2 = projectConfigs;
                return projectConfigs2;
            }
        }
        catch (IOException e) {
            logger.error("An error occurred while fetching the YAML configuration file.", (Throwable)e);
        }
        return null;
    }

    private static void processProject(GitCommissioningConfig config, ProjectManager projectManager) {
        try {
            logger.info("Starting to process project: " + config.getIgnitionProjectName());
            if (config.getRepoURI() == null || config.getRepoBranch() == null || config.getIgnitionProjectName() == null || config.getIgnitionUserName() == null || config.getUserName() == null || config.getUserPassword() == null && config.getSshKey() == null || config.getUserEmail() == null) {
                logger.error("Incomplete configuration for project: " + config.getIgnitionProjectName());
                throw new RuntimeException("Incomplete git configuration file.");
            }
            logger.info("Setting up Git configuration records");
            PersistenceInterface persistenceInterface = GatewayHook.context.getPersistenceInterface();
            GitProjectsConfigRecord projectsConfigRecord = (GitProjectsConfigRecord)persistenceInterface.createNew(GitProjectsConfigRecord.META);
            projectsConfigRecord.setProjectName(config.getIgnitionProjectName());
            projectsConfigRecord.setURI(config.getRepoURI());
            String userSecretFilePath = System.getenv("GATEWAY_GIT_USER_SECRET_FILE");
            if (userSecretFilePath != null) {
                config.setSecretFromFilePath(Paths.get(userSecretFilePath, new String[0]), projectsConfigRecord.isSSHAuthentication());
            }
            if (config.getSshKey() == null && config.getUserPassword() == null) {
                throw new Exception("Git User Password or SSHKey not configured.");
            }
            persistenceInterface.save((PersistentRecord)projectsConfigRecord);
            GitProjectsConfigRecord savedProject = (GitProjectsConfigRecord)persistenceInterface.queryOne(new SQuery(GitProjectsConfigRecord.META).eq((SFieldMeta)GitProjectsConfigRecord.ProjectName, (Object)config.getIgnitionProjectName()));
            if (savedProject == null) {
                throw new Exception("Failed to save project configuration record");
            }
            logger.info("Created project record with ID: " + savedProject.getId());
            GitReposUsersRecord reposUsersRecord = (GitReposUsersRecord)persistenceInterface.createNew(GitReposUsersRecord.META);
            reposUsersRecord.setUserName(config.getUserName());
            reposUsersRecord.setIgnitionUser(config.getIgnitionUserName());
            reposUsersRecord.setProjectId(savedProject.getId());
            if (projectsConfigRecord.isSSHAuthentication()) {
                reposUsersRecord.setSSHKey(config.getSshKey());
            } else {
                reposUsersRecord.setPassword(config.getUserPassword());
            }
            reposUsersRecord.setEmail(config.getUserEmail());
            persistenceInterface.save((PersistentRecord)reposUsersRecord);
            GitReposUsersRecord savedUser = (GitReposUsersRecord)persistenceInterface.queryOne(new SQuery(GitReposUsersRecord.META).eq((SFieldMeta)GitReposUsersRecord.ProjectId, (Object)savedProject.getId()).eq((SFieldMeta)GitReposUsersRecord.IgnitionUser, (Object)config.getIgnitionUserName()));
            if (savedUser == null) {
                throw new Exception("Failed to save user record");
            }
            logger.info("Created user record for project ID: " + savedProject.getId());
            logger.info("Creating project in Ignition");
            projectManager.createProject(config.getIgnitionProjectName(), new ProjectManifest(config.getIgnitionProjectName(), "", true, config.isIgnitionProjectInheritable(), config.getIgnitionProjectParentName()), new ArrayList());
            Path projectDir = GitManager.getProjectFolderPath(config.getIgnitionProjectName());
            logger.info("Deleting project directory at: " + projectDir);
            try {
                if (projectDir.toFile().exists()) {
                    FileUtils.deleteDirectory((File)projectDir.toFile());
                }
            }
            catch (IOException e) {
                logger.error("Failed to delete project directory", (Throwable)e);
                throw e;
            }
            logger.info("Cloning repository: " + config.getRepoURI() + " branch: " + config.getRepoBranch());
            GitManager.cloneRepo(config.getIgnitionProjectName(), config.getIgnitionUserName(), config.getRepoURI(), config.getRepoBranch());
            if (projectDir.toFile().exists()) {
                logger.info("Directory exists after clone, contents: " + String.join((CharSequence)", ", projectDir.toFile().list()));
                File gitDir = new File(projectDir.toFile(), ".git");
                if (!gitDir.exists()) {
                    logger.error("Git directory not found after clone");
                    throw new RuntimeException("Git clone failed - .git directory not created");
                }
            } else {
                logger.error("Project directory does not exist after clone attempt");
                throw new RuntimeException("Git clone failed - directory not created");
            }
            try (Git git = Git.open((File)projectDir.toFile());){
                logger.info("Cleaning git repository");
                git.clean().setCleanDirectories(true).setForce(true).setIgnore(false).call();
                logger.info("Resetting to origin/" + config.getRepoBranch());
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + config.getRepoBranch()).call();
                logger.info("Checking out branch: " + config.getRepoBranch());
                git.checkout().setName(config.getRepoBranch()).setForce(true).setForceRefUpdate(true).call();
            }
            logger.info("Importing project resources");
            GitProjectManager.importProject(config.getIgnitionProjectName());
            if (config.isImportTags()) {
                logger.info("Importing tags");
                GitTagManager.importTagManager(config.getIgnitionProjectName());
            }
            if (config.isImportThemes()) {
                logger.info("Importing themes");
                GitThemeManager.importTheme(config.getIgnitionProjectName());
            }
            if (config.isImportImages()) {
                logger.info("Importing images");
                GitImageManager.importImages(config.getIgnitionProjectName());
            }
            logger.info("Successfully completed processing project: " + config.getIgnitionProjectName());
        }
        catch (Exception e) {
            logger.error("Error processing project " + config.getIgnitionProjectName(), (Throwable)e);
            logger.error("Stack trace: ", (Throwable)e);
        }
    }

    private static String yamlKeyToFieldName(String yamlKey) {
        if (yamlKey.equals("repo_uri") || yamlKey.equals("repo_branch") || yamlKey.equals("ignition_projectName") || yamlKey.equals("ignition_userName") || yamlKey.equals("ignition_inheritable") || yamlKey.equals("ignition_parentName") || yamlKey.equals("user_name") || yamlKey.equals("user_email") || yamlKey.equals("user_password") || yamlKey.equals("commissioning_importThemes") || yamlKey.equals("commissioning_importTags") || yamlKey.equals("commissioning_importImages")) {
            return yamlKey;
        }
        String[] parts = yamlKey.split("_");
        StringBuilder fieldName = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            fieldName.append(parts[i].substring(0, 1).toUpperCase()).append(parts[i].substring(1));
        }
        return fieldName.toString();
    }
}

