/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.commissioning.utils;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.commissioning.GitCommissioningConfig;
import com.axone_io.ignition.git.managers.GitImageManager;
import com.axone_io.ignition.git.managers.GitManager;
import com.axone_io.ignition.git.managers.GitProjectManager;
import com.axone_io.ignition.git.managers.GitTagManager;
import com.axone_io.ignition.git.managers.GitThemeManager;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.axone_io.ignition.git.records.GitReposUsersRecord;
import com.google.common.eventbus.Subscribe;
import com.inductiveautomation.ignition.common.project.ProjectManifest;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistenceInterface;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistentRecord;
import com.inductiveautomation.ignition.gateway.project.ProjectManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SQuery;

public class GitCommissioningUtils_old {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitCommissioningUtils_old.class);
    public static GitCommissioningConfig config;

    @Subscribe
    public static void loadConfiguration() {
        Path dataDir = GitManager.getDataFolderPath();
        File ignitionConf = dataDir.resolve("git.conf").toFile();
        ProjectManager projectManager = GatewayHook.context.getProjectManager();
        try {
            if (ignitionConf.exists() && ignitionConf.isFile()) {
                config = GitCommissioningUtils_old.parseConfigLines(FileUtils.readFileToByteArray((File)ignitionConf));
                if (projectManager.getProjectNames().contains(config.getIgnitionProjectName())) {
                    logger.info("The configuration of the git module was interrupted because the project '" + config.getIgnitionProjectName() + "' already exist.");
                    return;
                }
                if (config.getRepoURI() == null || config.getRepoBranch() == null || config.getIgnitionProjectName() == null || config.getIgnitionUserName() == null || config.getUserName() == null || config.getUserPassword() == null && config.getSshKey() == null || config.getUserEmail() == null) {
                    throw new RuntimeException("Incomplete git configuration file.");
                }
                projectManager.createProject(config.getIgnitionProjectName(), new ProjectManifest(config.getIgnitionProjectName(), "", false, false, ""), new ArrayList());
                Path projectDir = GitManager.getProjectFolderPath(config.getIgnitionProjectName());
                GitManager.clearDirectory(projectDir);
                PersistenceInterface persistenceInterface = GatewayHook.context.getPersistenceInterface();
                SQuery query = new SQuery(GitProjectsConfigRecord.META).eq((SFieldMeta)GitProjectsConfigRecord.ProjectName, (Object)config.getIgnitionProjectName());
                if (persistenceInterface.queryOne(query) != null) {
                    logger.info("The configuration of the git module was interrupted because the GitProjectsConfigRecord '" + config.getIgnitionProjectName() + "' already exist.");
                    return;
                }
                GitProjectsConfigRecord projectsConfigRecord = (GitProjectsConfigRecord)persistenceInterface.createNew(GitProjectsConfigRecord.META);
                projectsConfigRecord.setProjectName(config.getIgnitionProjectName());
                projectsConfigRecord.setURI(config.getRepoURI());
                String userSecretFilePath = System.getenv("GATEWAY_GIT_USER_SECRET_FILE");
                if (userSecretFilePath != null) {
                    config.setSecretFromFilePath(Paths.get(userSecretFilePath, new String[0]), projectsConfigRecord.isSSHAuthentication());
                }
                if (config.getSshKey() == null && config.getUserPassword() == null) {
                    throw new Exception("Git User Password or SSHKey not configured.");
                }
                persistenceInterface.save((PersistentRecord)projectsConfigRecord);
                GitReposUsersRecord reposUsersRecord = (GitReposUsersRecord)persistenceInterface.createNew(GitReposUsersRecord.META);
                reposUsersRecord.setUserName(config.getUserName());
                reposUsersRecord.setIgnitionUser(config.getIgnitionUserName());
                reposUsersRecord.setProjectId(projectsConfigRecord.getId());
                if (projectsConfigRecord.isSSHAuthentication()) {
                    reposUsersRecord.setSSHKey(config.getSshKey());
                } else {
                    reposUsersRecord.setPassword(config.getUserPassword());
                }
                reposUsersRecord.setEmail(config.getUserEmail());
                persistenceInterface.save((PersistentRecord)reposUsersRecord);
                GitManager.cloneRepo(config.getIgnitionProjectName(), config.getIgnitionUserName(), config.getRepoURI(), config.getRepoBranch());
                GitProjectManager.importProject(config.getIgnitionProjectName());
                if (config.isImportTags()) {
                    GitTagManager.importTagManager(config.getIgnitionProjectName());
                }
                if (config.isImportThemes()) {
                    GitThemeManager.importTheme(config.getIgnitionProjectName());
                }
                if (config.isImportImages()) {
                    GitImageManager.importImages(config.getIgnitionProjectName());
                }
            } else {
                logger.info("No git configuration file was found.");
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while git configuration settings up.", (Throwable)e);
        }
    }

    protected static GitCommissioningConfig parseConfigLines(byte[] ignitionConf) {
        Pattern repoUriPattern = Pattern.compile("repo.uri");
        Pattern repoBranchPattern = Pattern.compile("repo.branch");
        Pattern projectNamePattern = Pattern.compile("ignition.project.name");
        Pattern ignitionUserName = Pattern.compile("ignition.user.name");
        Pattern userNamePattern = Pattern.compile("user.name");
        Pattern passwordPattern = Pattern.compile("user.password");
        Pattern emailPattern = Pattern.compile("user.email");
        Pattern sshKeyFilePath = Pattern.compile("user.shh.key.file.path");
        Pattern importTags = Pattern.compile("commissioning.import.tags");
        Pattern importThemes = Pattern.compile("commissioning.import.themes");
        Pattern importImages = Pattern.compile("commissioning.import.images");
        Pattern initDefaultBranch = Pattern.compile("init.defaultBranch");
        GitCommissioningConfig config = new GitCommissioningConfig();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(ignitionConf), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher repoUriMatcher = repoUriPattern.matcher(line);
                Matcher repoBranchMatcher = repoBranchPattern.matcher(line);
                Matcher projectNameMatcher = projectNamePattern.matcher(line);
                Matcher userNameMatcher = userNamePattern.matcher(line);
                Matcher passwordMatcher = passwordPattern.matcher(line);
                Matcher emailMatcher = emailPattern.matcher(line);
                Matcher ignitionUserNameMatcher = ignitionUserName.matcher(line);
                Matcher importTagsMatcher = importTags.matcher(line);
                Matcher importThemesMatcher = importThemes.matcher(line);
                Matcher importImagesMatcher = importImages.matcher(line);
                Matcher sshKeyFilePathMatcher = sshKeyFilePath.matcher(line);
                Matcher initDefaultBranchPathMatcher = initDefaultBranch.matcher(line);
                if (repoUriMatcher.find()) {
                    config.setRepoURI(line.split("=")[1]);
                    continue;
                }
                if (repoBranchMatcher.find()) {
                    config.setRepoBranch(line.split("=")[1]);
                    continue;
                }
                if (projectNameMatcher.find()) {
                    config.setIgnitionProjectName(line.split("=")[1]);
                    continue;
                }
                if (ignitionUserNameMatcher.find()) {
                    config.setIgnitionUserName(line.split("=")[1]);
                    continue;
                }
                if (userNameMatcher.find()) {
                    config.setUserName(line.split("=")[1]);
                    continue;
                }
                if (passwordMatcher.find()) {
                    config.setUserPassword(line.split("=")[1]);
                    continue;
                }
                if (emailMatcher.find()) {
                    config.setUserEmail(line.split("=")[1]);
                    continue;
                }
                if (importTagsMatcher.find()) {
                    config.setImportTags(Boolean.parseBoolean(line.split("=")[1]));
                    continue;
                }
                if (importThemesMatcher.find()) {
                    config.setImportThemes(Boolean.parseBoolean(line.split("=")[1]));
                    continue;
                }
                if (importImagesMatcher.find()) {
                    config.setImportImages(Boolean.parseBoolean(line.split("=")[1]));
                    continue;
                }
                if (sshKeyFilePathMatcher.find()) {
                    config.setSecretFromFilePath(Paths.get(line.split("=")[1], new String[0]), true);
                    continue;
                }
                if (!initDefaultBranchPathMatcher.find()) continue;
                config.setInitDefaultBranch(line.split("=")[1]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Invalid git configuration file.", e);
        }
        catch (Exception e) {
            logger.error("An error occurred while importing the Git configuration file.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return config;
    }
}

