/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.managers.GitManager;
import com.axone_io.ignition.git.managers.PathIcon;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.images.ImageFormat;
import com.inductiveautomation.ignition.gateway.images.ImageManager;
import com.inductiveautomation.ignition.gateway.images.ImageRecord;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistenceInterface;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistentRecord;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SQuery;
import simpleorm.dataset.SRecordMeta;

public class GitImageManager {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitImageManager.class);

    public static void importImages(String projectName) {
        Path projectDir = GitManager.getProjectFolderPath(projectName);
        File directory = projectDir.resolve("images").toFile();
        PersistenceInterface persistenceInterface = GatewayHook.context.getPersistenceInterface();
        List images = persistenceInterface.query(new SQuery((SRecordMeta)ImageRecord.META));
        images.forEach(i -> {
            i.deleteRecord();
            persistenceInterface.save((PersistentRecord)i);
        });
        File[] files = directory.listFiles();
        GitImageManager.uploadFiles(files != null ? files : new File[]{});
    }

    protected static void uploadFiles(File[] files) {
        for (File file : files) {
            if (file.isDirectory()) {
                GitImageManager.uploadFolder(file, "");
                continue;
            }
            GitImageManager.uploadFile(file, "");
        }
    }

    protected static void uploadFile(File f, String path) {
        String lName = f.getName().toLowerCase();
        if (lName.endsWith(".png") || lName.endsWith(".gif") || lName.endsWith(".jpg") || lName.endsWith(".jpeg") || lName.endsWith(".svg")) {
            try {
                String ext = lName.substring(lName.lastIndexOf(".") + 1).toUpperCase();
                byte[] bytes = Files.readAllBytes(f.toPath());
                int width = 0;
                int height = 0;
                Image img = Toolkit.getDefaultToolkit().createImage(bytes);
                if (PathIcon.waitForImage(img)) {
                    width = img.getWidth(null);
                    height = img.getHeight(null);
                }
                try {
                    GatewayHook.context.getImageManager().insertImage(f.getName(), "", ImageFormat.valueOf((String)ext), path, bytes, width, height, bytes.length);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("FileNotFound exception for file: '" + f.getPath() + "'");
            }
            catch (IOException e) {
                logger.error("IOException exception for file: '" + f.getPath() + "'");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static void uploadFolder(File dir, String path) {
        try {
            GatewayHook.context.getImageManager().insertImageFolder(dir.getName(), path.equals("") ? null : path);
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        GitImageManager.uploadFolder(file, path + dir.getName() + "/");
                        continue;
                    }
                    GitImageManager.uploadFile(file, path + dir.getName() + "/");
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void exportImages(Path projectFolderPath) {
        Path imageFolderPath = projectFolderPath.resolve("images");
        GitManager.clearDirectory(imageFolderPath);
        try {
            Files.createDirectories(imageFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        GitImageManager.saveFolderImage(imageFolderPath, "");
    }

    public static void saveFolderImage(Path folderPath, String directory) {
        ImageManager imageManager = GatewayHook.context.getImageManager();
        for (ImageRecord imageRecord : imageManager.getImages(directory)) {
            String path = imageRecord.getString((SFieldMeta)ImageRecord.Path);
            if (imageRecord.isDirectory()) {
                try {
                    Files.createDirectories(folderPath.resolve(path), new FileAttribute[0]);
                }
                catch (IOException e) {
                    logger.error(e.toString(), (Throwable)e);
                }
                GitImageManager.saveFolderImage(folderPath, path);
                continue;
            }
            byte[] data = imageManager.getImage(path).getBytes((SFieldMeta)ImageRecord.Data);
            try {
                Files.write(folderPath.resolve(path), data, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
    }
}

