/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.SshTransportConfigCallback;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.axone_io.ignition.git.records.GitReposUsersRecord;
import com.inductiveautomation.ignition.common.gson.Gson;
import com.inductiveautomation.ignition.common.gson.JsonElement;
import com.inductiveautomation.ignition.common.gson.JsonObject;
import com.inductiveautomation.ignition.common.project.RuntimeProject;
import com.inductiveautomation.ignition.common.project.resource.LastModification;
import com.inductiveautomation.ignition.common.project.resource.ProjectResource;
import com.inductiveautomation.ignition.common.project.resource.ResourcePath;
import com.inductiveautomation.ignition.common.project.resource.ResourceType;
import com.inductiveautomation.ignition.common.util.DatasetBuilder;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.project.ProjectManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SQuery;

public class GitManager {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitManager.class);

    public static Git getGit(Path projectFolderPath) {
        Git git;
        try {
            git = Git.open((File)projectFolderPath.resolve(".git").toFile());
            GitManager.disableSsl(git);
        }
        catch (IOException e) {
            logger.error("Unable to retrieve Git repository", (Throwable)e);
            throw new RuntimeException(e);
        }
        return git;
    }

    public static Path getProjectFolderPath(String projectName) {
        Path dataDir = GitManager.getDataFolderPath();
        return dataDir.resolve("projects").resolve(projectName);
    }

    public static Path getDataFolderPath() {
        return GatewayHook.context.getSystemManager().getDataDir().toPath();
    }

    public static void clearDirectory(Path folderPath) {
        try {
            if (folderPath.toFile().exists()) {
                FileUtils.cleanDirectory((File)folderPath.toFile());
            }
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
        }
    }

    public static void setAuthentication(TransportCommand<?, ?> command, String projectName, String userName) throws Exception {
        GitProjectsConfigRecord gitProjectsConfigRecord = GitManager.getGitProjectConfigRecord(projectName);
        GitReposUsersRecord user = GitManager.getGitReposUserRecord(gitProjectsConfigRecord, userName);
        GitManager.setAuthentication(command, gitProjectsConfigRecord, user);
    }

    public static void setAuthentication(TransportCommand<?, ?> command, GitProjectsConfigRecord gitProjectsConfigRecord, GitReposUsersRecord user) {
        if (gitProjectsConfigRecord.isSSHAuthentication()) {
            command.setTransportConfigCallback((TransportConfigCallback)GitManager.getSshTransportConfigCallback(user));
        } else {
            command.setCredentialsProvider((CredentialsProvider)GitManager.getUsernamePasswordCredentialsProvider(user));
        }
    }

    public static void setCommitAuthor(CommitCommand command, String projectName, String userName) {
        try {
            GitProjectsConfigRecord gitProjectsConfigRecord = GitManager.getGitProjectConfigRecord(projectName);
            GitReposUsersRecord user = GitManager.getGitReposUserRecord(gitProjectsConfigRecord, userName);
            command.setAuthor("", user.getEmail());
        }
        catch (Exception e) {
            logger.error("An error occurred while setting up commit author.", (Throwable)e);
        }
    }

    public static GitProjectsConfigRecord getGitProjectConfigRecord(String projectName) throws Exception {
        SQuery projectQuery = new SQuery(GitProjectsConfigRecord.META).eq((SFieldMeta)GitProjectsConfigRecord.ProjectName, (Object)projectName);
        GitProjectsConfigRecord gitProjectsConfigRecord = (GitProjectsConfigRecord)GatewayHook.context.getPersistenceInterface().queryOne(projectQuery);
        if (gitProjectsConfigRecord == null) {
            throw new Exception("Git Project not configured.");
        }
        return gitProjectsConfigRecord;
    }

    public static GitReposUsersRecord getGitReposUserRecord(GitProjectsConfigRecord gitProjectsConfigRecord, String userName) throws Exception {
        logger.info("Looking for Git user record - Project ID: " + gitProjectsConfigRecord.getId() + ", Username: " + userName);
        SQuery userQuery = new SQuery(GitReposUsersRecord.META).eq((SFieldMeta)GitReposUsersRecord.ProjectId, (Object)gitProjectsConfigRecord.getId()).eq((SFieldMeta)GitReposUsersRecord.IgnitionUser, (Object)userName);
        GitReposUsersRecord user = (GitReposUsersRecord)GatewayHook.context.getPersistenceInterface().queryOne(userQuery);
        if (user == null) {
            List allUsers = GatewayHook.context.getPersistenceInterface().query(new SQuery(GitReposUsersRecord.META));
            logger.error("Available Git users: " + allUsers.stream().map(u -> String.format("(ProjectId: %d, User: %s)", u.getProjectId(), u.getIgnitionUser())).collect(Collectors.joining(", ")));
            throw new Exception("Git User not configured. No user found for project " + gitProjectsConfigRecord.getId() + " and username " + userName);
        }
        return user;
    }

    public static UsernamePasswordCredentialsProvider getUsernamePasswordCredentialsProvider(GitReposUsersRecord user) {
        return new UsernamePasswordCredentialsProvider(user.getUserName(), user.getPassword());
    }

    public static SshTransportConfigCallback getSshTransportConfigCallback(GitReposUsersRecord user) {
        return new SshTransportConfigCallback(user.getSSHKey());
    }

    public static int countOccurrences(Set<String> list, String prefix) {
        int count = 0;
        for (String str : list) {
            if (!str.startsWith(prefix)) continue;
            ++count;
        }
        return count;
    }

    public static void uncommittedChangesBuilder(String projectName, Set<String> updates, String type, List<String> changes, DatasetBuilder builder) {
        for (String update : updates) {
            String[] rowData = new String[3];
            String actor = "unknown";
            String path = update;
            if (GitManager.hasActor(path)) {
                String[] pathSplitted = update.split("/");
                path = String.join((CharSequence)"/", Arrays.copyOf(pathSplitted, pathSplitted.length - 1));
                actor = GitManager.getActor(projectName, path);
            }
            rowData[0] = path;
            rowData[1] = type;
            if (changes.contains(path)) continue;
            rowData[2] = actor;
            changes.add(path);
            builder.addRow((Object[])rowData);
        }
    }

    public static boolean hasActor(String resource) {
        boolean hasActor = false;
        if (resource.startsWith("ignition")) {
            hasActor = Boolean.TRUE;
        }
        if (resource.startsWith("com.inductiveautomation.")) {
            hasActor = Boolean.TRUE;
        }
        return hasActor;
    }

    public static String getActor(String projectName, String path) {
        RuntimeProject project;
        Optional resourceOpt;
        ProjectManager projectManager = GatewayHook.context.getProjectManager();
        Optional projectOpt = projectManager.getProject(projectName);
        if (projectOpt.isPresent() && (resourceOpt = (project = (RuntimeProject)projectOpt.get()).getResource(GitManager.getResourcePath(path))).isPresent()) {
            ProjectResource projectResource = (ProjectResource)resourceOpt.get();
            return LastModification.of((ProjectResource)projectResource).map(LastModification::getActor).orElse("unknown");
        }
        return "unknown";
    }

    public static List getAddedFiles(String projectName) {
        ArrayList fileList = new ArrayList();
        Git git = GitManager.getGit(GitManager.getProjectFolderPath(projectName));
        try {
            Status status = git.status().call();
            fileList.addAll(status.getAdded());
            git.close();
        }
        catch (Exception e) {
            logger.info(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return fileList;
    }

    public static Git cloneRepo(String projectName, String userName, String repoUri, String branch) throws GitAPIException {
        Path projectDir = GitManager.getProjectFolderPath(projectName);
        logger.info("Cloning into directory: " + projectDir);
        try {
            GitProjectsConfigRecord projectConfig = GitManager.getGitProjectConfigRecord(projectName);
            GitReposUsersRecord user = GitManager.getGitReposUserRecord(projectConfig, userName);
            CloneCommand cloneCommand = Git.cloneRepository().setURI(repoUri).setBranch(branch).setDirectory(projectDir.toFile()).setCloneAllBranches(true);
            if (projectConfig.isSSHAuthentication()) {
                cloneCommand.setTransportConfigCallback((TransportConfigCallback)GitManager.getSshTransportConfigCallback(user));
            } else {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(user.getUserName(), user.getPassword()));
            }
            Git git = cloneCommand.call();
            GitManager.disableSsl(git);
            return git;
        }
        catch (Exception e) {
            logger.error("Failed to clone repository: " + repoUri, (Throwable)e);
            throw new GitAPIException("Repository clone failed", e){};
        }
    }

    public static ResourcePath getResourcePath(String resourcePath) {
        String moduleId = "";
        String typeId = "";
        String resource = "";
        String[] paths = resourcePath.split("/");
        if (paths.length > 0) {
            moduleId = paths[0];
        }
        if (paths.length > 1) {
            typeId = paths[1];
        }
        if (paths.length > 2) {
            resource = resourcePath.replace(moduleId + "/" + typeId + "/", "");
        }
        return new ResourcePath(new ResourceType(moduleId, typeId), resource);
    }

    public static void disableSsl(Git git) throws IOException {
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("http", null, "sslVerify", false);
        config.save();
    }

    public static boolean isUpdatedResource(String projectName, String resourcePath) {
        boolean isUpdatedResource;
        Path projectPath = GitManager.getProjectFolderPath(projectName);
        String filePath = projectPath.toAbsolutePath() + "\\" + resourcePath.replace("/", "\\");
        try (Repository repository = GitManager.getGit(projectPath).getRepository();){
            ObjectId headId = repository.resolve("HEAD");
            try (RevWalk revWalk = new RevWalk(repository);){
                RevCommit commit = revWalk.parseCommit((AnyObjectId)headId);
                RevTree tree = commit.getTree();
                try (TreeWalk treeWalk = new TreeWalk(repository);){
                    treeWalk.addTree((AnyObjectId)tree);
                    treeWalk.setRecursive(true);
                    treeWalk.setFilter((TreeFilter)PathFilter.create((String)resourcePath));
                    if (!treeWalk.next()) {
                        throw new IllegalStateException("Did not find expected file " + resourcePath);
                    }
                    ObjectId objectId = treeWalk.getObjectId(0);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try (ObjectReader reader = repository.newObjectReader();){
                        reader.open((AnyObjectId)objectId).copyTo((OutputStream)out);
                    }
                    Gson g = new Gson();
                    String contentBefore = out.toString();
                    JsonObject jsonBefore = (JsonObject)g.fromJson(contentBefore, JsonElement.class);
                    jsonBefore.remove("files");
                    jsonBefore.remove("attributes");
                    String contentAfter = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                    JsonObject jsonAfter = (JsonObject)g.fromJson(contentAfter, JsonElement.class);
                    jsonAfter.remove("files");
                    jsonAfter.remove("attributes");
                    isUpdatedResource = !jsonBefore.equals((Object)jsonAfter);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return isUpdatedResource;
    }
}

