/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.managers.GitManager;
import com.inductiveautomation.ignition.common.StringPath;
import com.inductiveautomation.ignition.common.gson.JsonSyntaxException;
import com.inductiveautomation.ignition.common.project.ProjectInvalidException;
import com.inductiveautomation.ignition.common.project.ProjectManifest;
import com.inductiveautomation.ignition.common.project.resource.ProjectResource;
import com.inductiveautomation.ignition.common.project.resource.ProjectResourceBuilder;
import com.inductiveautomation.ignition.common.project.resource.ProjectResourceManifest;
import com.inductiveautomation.ignition.common.project.resource.ResourcePath;
import com.inductiveautomation.ignition.common.project.resource.ResourceType;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.project.ProjectManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GitProjectManager {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitProjectManager.class);

    public static void importProject(String projectName) {
        ProjectManager projectManager = GatewayHook.context.getProjectManager();
        Path projectDir = GitManager.getProjectFolderPath(projectName);
        try {
            Set<ProjectResource> resources = GitProjectManager.importFromFolder(projectDir, projectName);
            ProjectManifest projectManifest = GitProjectManager.loadProjectManifest(projectDir);
            projectManager.createOrReplaceProject(projectName, projectManifest, new ArrayList<ProjectResource>(resources));
        }
        catch (ProjectInvalidException | IOException e) {
            logger.error("An error occurred while importing '" + projectName + "' project.", e);
            throw new RuntimeException(e);
        }
    }

    public static Set<Map.Entry<String, byte[]>> listFiles(Path projectPath) {
        HashSet<Map.Entry<String, byte[]>> resources = new HashSet<Map.Entry<String, byte[]>>();
        Stack<File> stack = new Stack<File>();
        File directory = projectPath.toFile();
        stack.push(directory);
        while (!stack.empty()) {
            File current = (File)stack.pop();
            File[] files = current.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (file.isDirectory()) {
                    stack.push(file);
                    continue;
                }
                try {
                    String path = file.getAbsolutePath().replace(projectPath.toFile().getAbsolutePath(), "");
                    path = path.substring(1);
                    path = path.replace("\\", "/");
                    resources.add(new AbstractMap.SimpleEntry<String, byte[]>(path, Files.readAllBytes(file.toPath())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resources;
    }

    public static boolean isAnIgnitionResource(String resource) {
        return !resource.startsWith(".git") && !resource.startsWith("tags") && !resource.startsWith("images") && !resource.startsWith("themes") && !resource.equals("project.json");
    }

    public static Set<ProjectResource> importFromFolder(Path projectPath, String projectName) throws ProjectInvalidException, IOException {
        HashSet<ProjectResource> resources = new HashSet<ProjectResource>();
        HashSet createdFolders = new HashSet();
        Set<Map.Entry<String, byte[]>> files = GitProjectManager.listFiles(projectPath);
        files.stream().collect(Collectors.groupingBy(e -> StringUtils.substringBeforeLast((String)((String)e.getKey()), (String)"/"))).forEach((resourcePath, listOfFileNodes) -> {
            StringPath stringPath = StringPath.parse((String)resourcePath);
            resources.addAll(GitProjectManager.createParentFolderResources(projectName, stringPath, createdFolders));
            String manifestPath = String.format("%s/%s", resourcePath, "resource.json");
            ProjectResourceManifest resourceManifest = GitProjectManager.removeResourceManifest(manifestPath, listOfFileNodes);
            if (resourceManifest != null) {
                Map<String, byte[]> dataMap = GitProjectManager.createDataMap(resourceManifest, listOfFileNodes);
                resources.add(GitProjectManager.createResourceBuilder(projectName, stringPath, resourceManifest, dataMap).build());
            } else if (!createdFolders.contains(stringPath)) {
                resources.add(GitProjectManager.createResourceBuilder(projectName, stringPath, ProjectResourceManifest.newBuilder().build(), new HashMap<String, byte[]>()).setFolder(true).build());
                createdFolders.add(stringPath);
            }
        });
        return resources;
    }

    private static ProjectResourceManifest removeResourceManifest(String manifestPath, List<Map.Entry<String, byte[]>> listOfFileNodes) {
        return listOfFileNodes.stream().filter(e -> manifestPath.equals(e.getKey())).findFirst().map(entry -> {
            listOfFileNodes.remove(entry);
            try {
                return ProjectResourceManifest.fromJson((String)new String((byte[])entry.getValue(), StandardCharsets.UTF_8));
            }
            catch (JsonSyntaxException e) {
                logger.infof("Malformed resource.json at %s, unable to remove", new Object[]{entry.getKey(), e});
                return null;
            }
        }).orElse(null);
    }

    private static List<ProjectResource> createParentFolderResources(String projectName, StringPath resourcePath, Set<StringPath> ignoreList) {
        ArrayList<ProjectResource> folders = new ArrayList<ProjectResource>();
        for (StringPath currentPath = resourcePath.getParentPath(); currentPath != null && currentPath.getPathLength() > 0 && !ignoreList.contains(currentPath); currentPath = currentPath.getParentPath()) {
            folders.add(GitProjectManager.createResourceBuilder(projectName, currentPath, ProjectResourceManifest.newBuilder().build(), new HashMap<String, byte[]>()).setFolder(true).build());
            ignoreList.add(currentPath);
        }
        return folders;
    }

    private static Map<String, byte[]> createDataMap(ProjectResourceManifest resourceManifest, List<Map.Entry<String, byte[]>> listOfFileNodes) {
        List allowedFiles = resourceManifest.getFiles();
        HashMap<String, byte[]> dataMap = new HashMap<String, byte[]>();
        listOfFileNodes.forEach(e -> {
            String filename = StringUtils.substringAfterLast((String)((String)e.getKey()), (String)"/");
            if (allowedFiles.contains(filename)) {
                dataMap.put(filename, (byte[])e.getValue());
            }
        });
        return dataMap;
    }

    private static ProjectResourceBuilder createResourceBuilder(String projectName, StringPath resourcePath, ProjectResourceManifest manifest, Map<String, byte[]> dataMap) {
        String moduleId = resourcePath.getPathComponent(0);
        String resourceType = resourcePath.getPathLength() > 1 ? resourcePath.getPathComponent(1) : null;
        String subPath = resourcePath.getPathLength() > 2 ? resourcePath.subPath().subPath().toString() : "";
        return ProjectResource.newBuilder().setProjectName(projectName).setResourcePath(new ResourcePath(new ResourceType(moduleId, resourceType), subPath)).setData(dataMap).setRestricted(manifest.isRestricted()).setAttributes(manifest.getAttributes()).setApplicationScope(manifest.getScope()).setDocumentation(manifest.getDocumentation()).setVersion(manifest.getVersion()).setOverridable(manifest.isOverridable());
    }

    public static ProjectManifest loadProjectManifest(Path projectPath) throws IOException {
        String json = new String(Files.readAllBytes(projectPath.resolve("project.json")), StandardCharsets.UTF_8);
        return ProjectManifest.fromJson((String)json);
    }
}

