/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.managers.GitManager;
import com.inductiveautomation.ignition.common.JsonUtilities;
import com.inductiveautomation.ignition.common.gson.JsonElement;
import com.inductiveautomation.ignition.common.gson.JsonObject;
import com.inductiveautomation.ignition.common.tags.TagUtilities;
import com.inductiveautomation.ignition.common.tags.config.CollisionPolicy;
import com.inductiveautomation.ignition.common.tags.config.TagConfigurationModel;
import com.inductiveautomation.ignition.common.tags.model.TagPath;
import com.inductiveautomation.ignition.common.tags.model.TagProvider;
import com.inductiveautomation.ignition.common.tags.paths.BasicTagPath;
import com.inductiveautomation.ignition.common.tags.paths.parser.TagPathParser;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import com.inductiveautomation.ignition.gateway.tags.model.GatewayTagManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class GitTagManager {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitTagManager.class);

    public static void importTagManager(String projectName) {
        File[] files;
        File tagsProjectDir;
        File[] files2;
        Path projectDir = GitManager.getProjectFolderPath(projectName);
        File udtsProjectDir = projectDir.resolve("tags").toFile();
        GatewayTagManager gatewayTagManager = GatewayHook.context.getTagManager();
        if (udtsProjectDir.exists() && (files2 = udtsProjectDir.listFiles()) != null) {
            for (File file : files2) {
                String udtProviderName = FilenameUtils.removeExtension((String)file.getName());
                TagProvider udtProvider = gatewayTagManager.getTagProvider(udtProviderName);
                if (udtProvider == null) continue;
                try {
                    udtProvider.importTagsAsync((TagPath)new BasicTagPath(""), FileUtils.readFileToString((File)file, (String)StandardCharsets.UTF_8.toString()), "JSON", CollisionPolicy.Overwrite, null);
                }
                catch (IOException e) {
                    logger.warn("An error occurred while importing '" + udtProviderName + "' tags.", (Throwable)e);
                }
            }
        }
        if ((tagsProjectDir = projectDir.resolve("tags").toFile()).exists() && (files = tagsProjectDir.listFiles()) != null) {
            for (File file : files) {
                String providerName = FilenameUtils.removeExtension((String)file.getName());
                TagProvider tagProvider = gatewayTagManager.getTagProvider(providerName);
                if (tagProvider == null) continue;
                try {
                    tagProvider.importTagsAsync((TagPath)new BasicTagPath(""), FileUtils.readFileToString((File)file, (String)StandardCharsets.UTF_8.toString()), "JSON", CollisionPolicy.Overwrite, null);
                }
                catch (IOException e) {
                    logger.warn("An error occurred while importing '" + providerName + "' tags.", (Throwable)e);
                }
            }
        }
    }

    public static void exportTag(Path projectFolderPath) {
        try {
            Path tagFolderPath = projectFolderPath.resolve("tags");
            GitManager.clearDirectory(tagFolderPath);
            Files.createDirectories(tagFolderPath, new FileAttribute[0]);
            for (TagProvider tagProvider : GatewayHook.context.getTagManager().getTagProviders()) {
                TagPath typesPath = TagPathParser.parse((String)"");
                ArrayList<TagPath> tagPaths = new ArrayList<TagPath>();
                tagPaths.add(typesPath);
                CompletableFuture cfTagModels = tagProvider.getTagConfigsAsync(tagPaths, true, true);
                List tModels = (List)cfTagModels.get();
                Collections.reverse(tModels);
                JsonObject json = TagUtilities.toJsonObject((TagConfigurationModel)((TagConfigurationModel)tModels.get(0)));
                JsonElement sortedJson = JsonUtilities.createDeterministicCopy((JsonElement)json);
                Path newFile = tagFolderPath.resolve(tagProvider.getName() + ".json");
                Files.writeString(newFile, (CharSequence)TagUtilities.TAG_GSON.toJson(sortedJson), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

