/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.managers.GitManager;
import com.inductiveautomation.ignition.common.JsonUtilities;
import com.inductiveautomation.ignition.common.gson.Gson;
import com.inductiveautomation.ignition.common.gson.JsonElement;
import com.inductiveautomation.ignition.common.gson.JsonObject;
import com.inductiveautomation.ignition.common.util.LoggerEx;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class GitThemeManager {
    private static final LoggerEx logger = LoggerEx.newBuilder().build(GitThemeManager.class);

    public static void importTheme(String projectName) {
        File[] files;
        Path dataDir = GitManager.getDataFolderPath();
        Path projectDir = GitManager.getProjectFolderPath(projectName);
        Path themesDir = dataDir.resolve("modules").resolve("com.inductiveautomation.perspective").resolve("themes");
        Path themesProjectDir = projectDir.resolve("themes");
        File themesProjectDirFile = themesProjectDir.toFile();
        if (themesProjectDirFile.exists() && (files = themesProjectDirFile.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String themeName = FilenameUtils.removeExtension((String)file.getName());
                try {
                    Path destinationDirectoryMain = themesDir.resolve(file.getName());
                    Path sourceDirectoryMain = themesProjectDir.resolve(file.getName());
                    Files.copy(sourceDirectoryMain, destinationDirectoryMain, StandardCopyOption.REPLACE_EXISTING);
                    File destinationDirectory = themesDir.resolve(themeName).toFile();
                    File sourceDirectory = themesProjectDir.resolve(themeName).toFile();
                    FileUtils.deleteDirectory((File)destinationDirectory);
                    FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
                }
                catch (IOException e) {
                    logger.warn("An error occurred while importing '" + themeName + "' theme.", (Throwable)e);
                }
            }
        }
    }

    public static void exportTheme(Path projectFolderPath) {
        try {
            Path sessionPropsPath = projectFolderPath.resolve("com.inductiveautomation.perspective").resolve("session-props").resolve("props.json");
            String content = Files.readString(sessionPropsPath);
            Gson g = new Gson();
            JsonObject json = (JsonObject)g.fromJson(content, JsonObject.class);
            String theme = JsonUtilities.readString((JsonElement)json, (String)"props.theme", (String)"light");
            Path themesDir = GitManager.getDataFolderPath().resolve("modules").resolve("com.inductiveautomation.perspective").resolve("themes");
            Path themeFolder = themesDir.resolve(theme);
            Path themeFile = themesDir.resolve(theme + ".css");
            Path themeFolderPath = projectFolderPath.resolve("themes");
            GitManager.clearDirectory(themeFolderPath);
            Files.createDirectories(themeFolderPath, new FileAttribute[0]);
            FileUtils.copyDirectoryToDirectory((File)themeFolder.toFile(), (File)themeFolderPath.toFile());
            Files.copy(themeFile, themeFolderPath.resolve(themeFile.getFileName()), new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
    }
}

