/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.web;

import com.axone_io.ignition.git.GatewayHook;
import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.axone_io.ignition.git.web.GitProjectsConfigEditPage;
import com.axone_io.ignition.git.web.GitReposUsersPage;
import com.inductiveautomation.ignition.gateway.localdb.persistence.PersistentRecord;
import com.inductiveautomation.ignition.gateway.localdb.persistence.RecordMeta;
import com.inductiveautomation.ignition.gateway.web.components.ConfigPanel;
import com.inductiveautomation.ignition.gateway.web.components.RecordActionTable;
import com.inductiveautomation.ignition.gateway.web.components.actions.AbstractRecordInstanceAction;
import com.inductiveautomation.ignition.gateway.web.components.actions.EditRecordAction;
import com.inductiveautomation.ignition.gateway.web.components.actions.NewRecordAction;
import com.inductiveautomation.ignition.gateway.web.models.DefaultConfigTab;
import com.inductiveautomation.ignition.gateway.web.models.IConfigTab;
import com.inductiveautomation.ignition.gateway.web.models.RecordTypeNameModel;
import com.inductiveautomation.ignition.gateway.web.pages.IConfigPage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;

public class GitProjectsConfigPage
extends RecordActionTable<GitProjectsConfigRecord> {
    public static final IConfigTab MENU_ENTRY = DefaultConfigTab.builder().category(GatewayHook.CONFIG_CATEGORY).name("projects").i18n("bundle_git.Config.Git.Projects.MenuTitle").page(GitProjectsConfigPage.class).terms(new String[]{"git", "projects", "users", "ssh"}).build();

    public GitProjectsConfigPage(IConfigPage configPage) {
        super(configPage);
    }

    protected RecordMeta<GitProjectsConfigRecord> getRecordMeta() {
        return GitProjectsConfigRecord.META;
    }

    protected WebMarkupContainer newRecordAction(String id) {
        return new NewRecordAction<GitProjectsConfigRecord>(id, this.configPage, (ConfigPanel)this, GitProjectsConfigRecord.META){
            private static final long serialVersionUID = 1L;

            protected ConfigPanel newRecordEditPanel(GitProjectsConfigRecord newRecord) {
                return new GitProjectsConfigEditPage(this.getConfigPage(), GitProjectsConfigPage.this, newRecord);
            }

            protected void setupNewRecord(GitProjectsConfigRecord record) {
            }
        };
    }

    protected WebMarkupContainer newEditRecordAction(String id, GitProjectsConfigRecord record) {
        if (record.getId() == -1L) {
            return null;
        }
        return new EditRecordAction<GitProjectsConfigRecord>(id, this.configPage, (ConfigPanel)this, record){
            private static final long serialVersionUID = 1L;

            protected ConfigPanel createPanel(GitProjectsConfigRecord record) {
                return new GitProjectsConfigEditPage(this.getConfigPage(), GitProjectsConfigPage.this, record);
            }
        };
    }

    protected void addRecordInstanceActions(RepeatingView view, GitProjectsConfigRecord main) {
        super.addRecordInstanceActions(view, (PersistentRecord)main);
        view.add(new Component[]{new ManageAction(view.newChildId(), this.configPage, (ConfigPanel)this, main)});
    }

    public Pair<String, String> getMenuLocation() {
        return MENU_ENTRY.getMenuLocation();
    }

    private static class ManageAction
    extends AbstractRecordInstanceAction<GitProjectsConfigRecord> {
        public ManageAction(String id, IConfigPage configPage, ConfigPanel parentPanel, GitProjectsConfigRecord record) {
            super(id, configPage, parentPanel, (PersistentRecord)record);
        }

        protected ConfigPanel createPanel(GitProjectsConfigRecord record) {
            return new GitReposUsersPage(this.getConfigPage(), record);
        }

        protected String getCssClass() {
            return "view";
        }

        public IModel getLabel() {
            return new RecordTypeNameModel(GitProjectsConfigRecord.META, "Config.Projects.UserLink");
        }
    }
}

