/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.web.ProjectList;

import com.axone_io.ignition.git.records.GitProjectsConfigRecord;
import com.inductiveautomation.ignition.gateway.localdb.persistence.FormMeta;
import com.inductiveautomation.ignition.gateway.model.GatewayContext;
import com.inductiveautomation.ignition.gateway.model.IgnitionWebApp;
import com.inductiveautomation.ignition.gateway.web.components.RecordEditMode;
import com.inductiveautomation.ignition.gateway.web.components.editors.AbstractEditor;
import com.inductiveautomation.ignition.gateway.web.models.IRecordFieldComponent;
import com.inductiveautomation.ignition.gateway.web.models.LenientResourceModel;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SQuery;
import simpleorm.dataset.SRecordInstance;

public class ProjectSourceEditor
extends AbstractEditor {
    public ProjectSourceEditor(String id, FormMeta formMeta, RecordEditMode editMode, SRecordInstance record) {
        super(id, formMeta, editMode, record);
        ProjectDropdownChoice dropdown = new ProjectDropdownChoice("editor", record, editMode);
        formMeta.installValidators((FormComponent)dropdown);
        dropdown.setLabel((IModel)new LenientResourceModel(formMeta.getFieldNameKey()));
        this.add(new Component[]{dropdown});
    }

    private class ProjectDropdownChoice
    extends DropDownChoice<String>
    implements IRecordFieldComponent {
        public ProjectDropdownChoice(String id, SRecordInstance record, RecordEditMode editMode) {
            super(id);
            GatewayContext context = ((IgnitionWebApp)Application.get()).getContext();
            List stores = context.getProjectManager().getProjectNames();
            SQuery query = new SQuery(GitProjectsConfigRecord.META);
            List results = context.getPersistenceInterface().query(query);
            GitProjectsConfigRecord gitRecord = (GitProjectsConfigRecord)record;
            for (GitProjectsConfigRecord p : results) {
                if (editMode == RecordEditMode.EDIT && p.getProjectName().equals(gitRecord.getProjectName())) continue;
                stores.remove(p.getProjectName());
            }
            this.setChoices(stores);
        }

        public SFieldMeta getFieldMeta() {
            return ProjectSourceEditor.this.getFormMeta().getField();
        }
    }
}

