/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git;

import com.axone_io.ignition.git.components.SelectAllHeader;
import com.inductiveautomation.ignition.designer.gui.CommonUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.StyleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitPopup
extends JFrame {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JPanel panel;
    private JTextArea messageTextArea;
    private JLabel messageLabel;
    private JButton commitBtn;
    private JButton cancelBtn;
    private JLabel changesLabel;
    private JTable changesTable;

    public CommitPopup(Object[][] data, Component parent) {
        this.$$$setupUI$$$();
        try {
            InputStream commitIconStream = this.getClass().getResourceAsStream("/com/axone_io/ignition/git/icons/ic_commit.svg");
            ImageIcon commitIcon = new ImageIcon(ImageIO.read(commitIconStream));
            this.setIconImage(commitIcon.getImage());
        }
        catch (IOException e2) {
            this.logger.trace(e2.toString(), (Throwable)e2);
        }
        this.setContentPane(this.panel);
        this.setTitle("Commit");
        this.setSize(500, 500);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.changesTable.setAutoResizeMode(3);
        this.changesTable.getTableHeader().setReorderingAllowed(false);
        this.setData(data);
        this.commitBtn.addActionListener(e -> {
            ArrayList<String> changes = new ArrayList<String>();
            for (int i = 0; i < this.changesTable.getModel().getRowCount(); ++i) {
                if (!((Boolean)this.changesTable.getValueAt(i, 0)).booleanValue()) continue;
                changes.add((String)this.changesTable.getValueAt(i, 1));
            }
            this.onActionPerformed(changes, this.messageTextArea.getText());
            this.dispose();
        });
        this.cancelBtn.addActionListener(e -> this.dispose());
        this.pack();
        CommonUI.centerComponent((Component)this, (Component)parent);
        this.toFront();
    }

    public void resetMessage() {
        this.messageTextArea.setText("");
    }

    public void setData(Object[][] data) {
        Object[] columnNames = new String[]{"", "Resource Name", "Type", "Author"};
        DefaultTableModel model = new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        this.changesTable.setModel(model);
        this.changesTable.getColumn("").setPreferredWidth(20);
        this.changesTable.getColumn("Resource Name").setPreferredWidth(330);
        this.changesTable.getColumn("Type").setPreferredWidth(100);
        this.changesTable.getColumn("Author").setPreferredWidth(100);
        TableColumn tc = this.changesTable.getColumnModel().getColumn(0);
        tc.setHeaderRenderer(new SelectAllHeader(this.changesTable, 0));
    }

    public void onActionPerformed(List<String> changes, String message) {
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(5, 5, 5, 5), -1, -1));
        this.panel.setPreferredSize(new Dimension(500, 500));
        this.messageLabel = new JLabel();
        Font messageLabelFont = this.$$$getFont$$$(null, 1, -1, this.messageLabel.getFont());
        if (messageLabelFont != null) {
            this.messageLabel.setFont(messageLabelFont);
        }
        this.messageLabel.setText("Your commit message :");
        this.panel.add((Component)this.messageLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.commitBtn = new JButton();
        this.commitBtn.setBackground(new Color(-11555609));
        this.commitBtn.setForeground(new Color(-1));
        this.commitBtn.setText("Commit");
        this.panel.add((Component)this.commitBtn, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.cancelBtn = new JButton();
        this.cancelBtn.setText("Cancel");
        this.panel.add((Component)this.cancelBtn, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.changesLabel = new JLabel();
        Font changesLabelFont = this.$$$getFont$$$(null, 1, -1, this.changesLabel.getFont());
        if (changesLabelFont != null) {
            this.changesLabel.setFont(changesLabelFont);
        }
        this.changesLabel.setText("Changes :");
        this.panel.add((Component)this.changesLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        this.panel.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 2, 0, 3, 5, 5, null, null, null, 0, false));
        this.changesTable = new JTable();
        scrollPane1.setViewportView(this.changesTable);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)panel1, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-4143670)), null, 0, 0, null, null));
        this.messageTextArea = new JTextArea();
        this.messageTextArea.setText("");
        panel1.add((Component)this.messageTextArea, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 4, null, new Dimension(150, 50), null, 0, false));
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

