/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git;

import com.axone_io.ignition.git.GitScriptInterface;
import com.axone_io.ignition.git.actions.GitBaseAction;
import com.axone_io.ignition.git.utils.IconUtils;
import com.inductiveautomation.ignition.client.gateway_interface.ModuleRPCFactory;
import com.inductiveautomation.ignition.common.BundleUtil;
import com.inductiveautomation.ignition.common.SessionInfo;
import com.inductiveautomation.ignition.common.licensing.LicenseState;
import com.inductiveautomation.ignition.common.project.ChangeOperation;
import com.inductiveautomation.ignition.common.script.ScriptManager;
import com.inductiveautomation.ignition.designer.gui.DesignerToolbar;
import com.inductiveautomation.ignition.designer.gui.StatusBar;
import com.inductiveautomation.ignition.designer.model.AbstractDesignerModuleHook;
import com.inductiveautomation.ignition.designer.model.DesignerContext;
import com.inductiveautomation.ignition.designer.model.SaveContext;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class DesignerHook
extends AbstractDesignerModuleHook {
    public static GitScriptInterface rpc = (GitScriptInterface)ModuleRPCFactory.create((String)"com.axone_io.ignition.git", GitScriptInterface.class, (Class[])new Class[0]);
    public static List<ChangeOperation> changes = new ArrayList<ChangeOperation>();
    public static DesignerContext context;
    public static String projectName;
    public static String userName;
    JPanel gitStatusBar;
    Timer gitUserTimer;

    public void initializeScriptManager(ScriptManager manager) {
        super.initializeScriptManager(manager);
    }

    public void startup(DesignerContext context, LicenseState activationState) throws Exception {
        super.startup(context, activationState);
        DesignerHook.context = context;
        BundleUtil.get().addBundle("DesignerHook", ((Object)((Object)this)).getClass(), "DesignerHook");
        projectName = context.getProjectName();
        Optional sessionInfo = context.getResourceEditManager().getCurrentSessionInfo();
        userName = sessionInfo.isPresent() ? ((SessionInfo)sessionInfo.get()).getUsername() : "";
        rpc.setupLocalRepo(projectName, userName);
        this.initStatusBar();
        this.initToolBar();
    }

    private void initStatusBar() {
        StatusBar statusBar = context.getStatusBar();
        this.gitStatusBar = new JPanel();
        JLabel gitIconLabel = new JLabel(IconUtils.getIcon("/com/axone_io/ignition/git/icons/ic_git.svg"));
        gitIconLabel.setSize(35, 35);
        this.gitStatusBar.add(gitIconLabel);
        this.gitStatusBar.add(new JLabel(userName));
        boolean userValid = rpc.isRegisteredUser(projectName, userName);
        String userIconPath = userValid ? "/com/axone_io/ignition/git/icons/ic_verified_user.svg" : "/com/axone_io/ignition/git/icons/ic_unregister_user.svg";
        JLabel labelUserIcon = new JLabel(IconUtils.getIcon(userIconPath));
        labelUserIcon.setSize(35, 35);
        this.gitStatusBar.add(labelUserIcon);
        statusBar.addDisplay((JComponent)this.gitStatusBar);
        this.gitUserTimer = new Timer(10000, e -> {
            boolean valid = rpc.isRegisteredUser(projectName, userName);
            String userIconPath1 = valid ? "/com/axone_io/ignition/git/icons/ic_verified_user.svg" : "/com/axone_io/ignition/git/icons/ic_unregister_user.svg";
            labelUserIcon.setIcon(IconUtils.getIcon(userIconPath1));
        });
        this.gitUserTimer.start();
    }

    private void initToolBar() {
        DockableBarManager toolBarManager = context.getToolbarManager();
        DesignerToolbar toolbar = new DesignerToolbar("Git", "DesignerHook.Toolbar.Name");
        toolbar.add((Action)((Object)new GitBaseAction(GitBaseAction.GitActionType.PUSH)));
        toolbar.add((Action)((Object)new GitBaseAction(GitBaseAction.GitActionType.PULL)));
        toolbar.add((Action)((Object)new GitBaseAction(GitBaseAction.GitActionType.COMMIT)));
        toolbar.add((Action)((Object)new GitBaseAction(GitBaseAction.GitActionType.EXPORT)));
        toolbar.add((Action)((Object)new GitBaseAction(GitBaseAction.GitActionType.REPO)));
        toolBarManager.addDockableBar((DockableBar)toolbar);
    }

    public void notifyProjectSaveStart(SaveContext save) {
        changes = context.getProject().getChanges();
        super.notifyProjectSaveStart(save);
    }

    public void notifyProjectSaveDone() {
        super.notifyProjectSaveDone();
    }

    public void shutdown() {
        super.shutdown();
        DockableBarManager toolBarManager = context.getToolbarManager();
        toolBarManager.removeDockableBar("Git");
        StatusBar statusBar = context.getStatusBar();
        statusBar.removeDisplay((JComponent)this.gitStatusBar);
        this.gitUserTimer.stop();
    }
}

