/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.actions;

import com.axone_io.ignition.git.DesignerHook;
import com.axone_io.ignition.git.managers.GitActionManager;
import com.axone_io.ignition.git.utils.IconUtils;
import com.inductiveautomation.ignition.client.util.action.BaseAction;
import com.inductiveautomation.ignition.client.util.gui.ErrorUtil;
import com.inductiveautomation.ignition.common.BundleUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitBaseAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(GitBaseAction.class);
    GitActionType type;

    public GitBaseAction(GitActionType type) {
        super(type.baseBundleKey, type.getIcon());
        this.type = type;
    }

    public void actionPerformed(ActionEvent e) {
        GitBaseAction.handleAction(this.type);
    }

    public static void handleCommitAction(List<String> changes, String commitMessage) {
        String message = BundleUtil.get().getStringLenient(GitActionType.COMMIT.baseBundleKey + ".ConfirmMessage");
        int messageType = 1;
        try {
            DesignerHook.rpc.commit(DesignerHook.projectName, DesignerHook.userName, changes, commitMessage);
            SwingUtilities.invokeLater(new Thread(() -> GitActionManager.showConfirmPopup(message, messageType)));
        }
        catch (Exception ex) {
            ErrorUtil.showError((Throwable)ex);
        }
    }

    public static void handlePullAction(boolean importTags, boolean importTheme, boolean importImages) {
        String message = BundleUtil.get().getStringLenient(GitActionType.PULL.baseBundleKey + ".ConfirmMessage");
        int messageType = 1;
        try {
            DesignerHook.rpc.pull(DesignerHook.projectName, DesignerHook.userName, importTags, importTheme, importImages);
            SwingUtilities.invokeLater(new Thread(() -> GitActionManager.showConfirmPopup(message, messageType)));
        }
        catch (Exception ex) {
            ErrorUtil.showError((Throwable)ex);
        }
    }

    public static void handleAction(GitActionType type) {
        String message = BundleUtil.get().getStringLenient(type.baseBundleKey + ".ConfirmMessage");
        int messageType = 1;
        boolean confirmPopup = Boolean.TRUE;
        try {
            switch (type) {
                case PULL: {
                    confirmPopup = Boolean.FALSE;
                    GitActionManager.showPullPopup(DesignerHook.projectName, DesignerHook.userName);
                    break;
                }
                case PUSH: {
                    DesignerHook.rpc.push(DesignerHook.projectName, DesignerHook.userName);
                    break;
                }
                case COMMIT: {
                    confirmPopup = Boolean.FALSE;
                    GitActionManager.showCommitPopup(DesignerHook.projectName, DesignerHook.userName);
                    break;
                }
                case EXPORT: {
                    DesignerHook.rpc.exportConfig(DesignerHook.projectName);
                    break;
                }
                case REPO: {
                    GitActionManager.openRepositoryLink();
                }
            }
            if (confirmPopup) {
                SwingUtilities.invokeLater(new Thread(() -> GitActionManager.showConfirmPopup(message, messageType)));
            }
        }
        catch (Exception ex) {
            ErrorUtil.showError((Throwable)ex);
        }
    }

    public static enum GitActionType {
        PULL("DesignerHook.Actions.Pull", "/com/axone_io/ignition/git/icons/ic_pull.svg"),
        PUSH("DesignerHook.Actions.Push", "/com/axone_io/ignition/git/icons/ic_push.svg"),
        COMMIT("DesignerHook.Actions.Commit", "/com/axone_io/ignition/git/icons/ic_commit.svg"),
        EXPORT("DesignerHook.Actions.ExportGatewayConfig", "/com/axone_io/ignition/git/icons/ic_folder.svg"),
        REPO("DesignerHook.Actions.Repo", "/com/axone_io/ignition/git/icons/ic_repo.svg");

        private final String baseBundleKey;
        private final String resourcePath;

        private GitActionType(String baseBundleKey, String resourcePath) {
            this.baseBundleKey = baseBundleKey;
            this.resourcePath = resourcePath;
        }

        public Icon getIcon() {
            return IconUtils.getIcon(this.resourcePath);
        }
    }
}

