/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAllHeader
extends JCheckBox
implements TableCellRenderer {
    private JTable table;
    private TableModel tableModel;
    private JTableHeader header;
    private TableColumnModel tcm;
    private int targetColumn;
    private int viewColumn;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SelectAllHeader(JTable table, int targetColumn) {
        this.table = table;
        this.tableModel = table.getModel();
        if (this.tableModel.getColumnClass(targetColumn) != Boolean.class) {
            throw new IllegalArgumentException("Boolean column required.");
        }
        this.targetColumn = targetColumn;
        this.header = table.getTableHeader();
        this.setHorizontalAlignment(0);
        this.tcm = table.getColumnModel();
        this.applyUI();
        this.addItemListener(new ItemHandler());
        this.header.addMouseListener(new MouseHandler());
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, new Color(-4143670)));
        this.tableModel.addTableModelListener(new ModelHandler());
        this.refreshState();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.applyUI();
    }

    private void applyUI() {
        this.setFont(UIManager.getFont("TableHeader.font"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
    }

    private boolean needsToggle() {
        boolean allTrue = true;
        boolean allFalse = true;
        for (int r = 0; r < this.tableModel.getRowCount(); ++r) {
            boolean b = (Boolean)this.tableModel.getValueAt(r, this.targetColumn);
            allTrue &= b;
            allFalse &= !b;
        }
        return allTrue && !this.isSelected() || allFalse && this.isSelected();
    }

    private void refreshState() {
        if (this.needsToggle()) {
            this.doClick();
            this.header.repaint();
        }
    }

    private class ItemHandler
    implements ItemListener {
        private ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean state = e.getStateChange() == 1;
            SelectAllHeader.this.setSelected(state);
            for (int r = 0; r < SelectAllHeader.this.table.getRowCount(); ++r) {
                SelectAllHeader.this.table.setValueAt(state, r, SelectAllHeader.this.viewColumn);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SelectAllHeader.this.viewColumn = SelectAllHeader.this.header.columnAtPoint(e.getPoint());
            int modelColumn = SelectAllHeader.this.tcm.getColumn(SelectAllHeader.this.viewColumn).getModelIndex();
            if (modelColumn == SelectAllHeader.this.targetColumn) {
                SelectAllHeader.this.doClick();
                SelectAllHeader.this.header.repaint();
            }
        }
    }

    private class ModelHandler
    implements TableModelListener {
        private ModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            SelectAllHeader.this.refreshState();
        }
    }
}

