/*
 * Decompiled with CFR 0.152.
 */
package com.axone_io.ignition.git.managers;

import com.axone_io.ignition.git.CommitPopup;
import com.axone_io.ignition.git.DesignerHook;
import com.axone_io.ignition.git.PullPopup;
import com.axone_io.ignition.git.actions.GitBaseAction;
import com.inductiveautomation.ignition.common.Dataset;
import com.inductiveautomation.ignition.common.project.ChangeOperation;
import com.inductiveautomation.ignition.common.project.resource.ProjectResourceId;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitActionManager {
    static CommitPopup commitPopup;
    static PullPopup pullPopup;
    private static final Logger logger;

    public static Object[][] getCommitPopupData(String projectName, String userName) {
        List<ChangeOperation> changes = DesignerHook.changes;
        logger.debug("Total number of change operations: {}", (Object)changes.size());
        Dataset ds = DesignerHook.rpc.getUncommitedChanges(projectName, userName);
        Object[][] data = new Object[ds.getRowCount()][];
        ArrayList<String> resourcesChangedId = new ArrayList<String>();
        for (ChangeOperation c : changes) {
            ProjectResourceId pri = ChangeOperation.getResourceIdFromChange((ChangeOperation)c);
            resourcesChangedId.add(pri.getResourcePath().toString());
            logger.debug("ChangeOperation Type: {}, Resource: {}", (Object)c.getOperationType(), (Object)pri.getResourcePath());
        }
        for (int i = 0; i < ds.getRowCount(); ++i) {
            String resource = (String)ds.getValueAt(i, "resource");
            boolean toAdd = resourcesChangedId.contains(resource);
            Object[] row = new Object[]{toAdd, resource, ds.getValueAt(i, "type"), ds.getValueAt(i, "actor")};
            logger.debug("Resource: {}, Add to commit popup: {}", (Object)resource, (Object)toAdd);
            data[i] = row;
        }
        return data;
    }

    public static void showCommitPopup(String projectName, String userName) {
        Object[][] data = GitActionManager.getCommitPopupData(projectName, userName);
        if (commitPopup != null) {
            commitPopup.setData(data);
            commitPopup.setVisible(true);
            commitPopup.toFront();
        } else {
            commitPopup = new CommitPopup(data, DesignerHook.context.getFrame()){

                @Override
                public void onActionPerformed(List<String> changes, String commitMessage) {
                    GitBaseAction.handleCommitAction(changes, commitMessage);
                    this.resetMessage();
                }
            };
        }
    }

    public static void openRepositoryLink() {
        try {
            Desktop desktop = Desktop.getDesktop();
            String repoLink = "https://github.com";
            desktop.browse(new URI(repoLink));
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Error opening repository link", (Throwable)e);
        }
    }

    public static void showPullPopup(String projectName, String userName) {
        if (pullPopup != null) {
            pullPopup.setVisible(true);
            pullPopup.toFront();
        } else {
            pullPopup = new PullPopup((Component)DesignerHook.context.getFrame()){

                @Override
                public void onPullAction(boolean importTags, boolean importTheme, boolean importImages) {
                    GitBaseAction.handlePullAction(importTags, importTheme, importImages);
                    this.resetCheckboxes();
                }
            };
        }
    }

    public static void showConfirmPopup(String message, int messageType) {
        JOptionPane.showConfirmDialog(DesignerHook.context.getFrame(), message, "Info", -1, messageType);
    }

    static {
        logger = LoggerFactory.getLogger(GitActionManager.class);
    }
}

